//
//****************************************
//**  Copyright  (C)  W.ch  1999-2011   **
//**  Web:  http://www.winchiphead.com  **
//****************************************
//**  DLL for HID interface chip CH9329  **
//**  C, VC6.0                          **
//****************************************
//
// HIDӦòӿڿ  V1.1
// Ͼߺ޹˾  : zyw@wch.cn 2014.08
// HIDDLL  V1.1 
// 
// 
//

#ifndef		_CH9329_DLL_H
#define		_CH9329_DLL_H

#ifdef __cplusplus
extern "C" {
#endif

/*	BAUD rate setting	*/
#define B300		0x01
#define B600		0x02
#define B1200		0x03
#define B2400		0x04
#define B4800		0x05
#define B9600		0x06
#define B14400      0x07
#define B19200		0x08
#define B28800      0x09
#define B38400		0x0A
#define B57600		0x0B
#define B76800      0x0C
#define B115200 	0x0D

/* Parity define	*/
#define P_ODD		0x01        //У
#define P_EVEN		0x02		//żУ
#define P_SPC		0x03		//հλ
#define P_NONE		0x04		//У

/*	Data bits define		*/
#define BIT_5		0x01			
#define BIT_6		0x02
#define BIT_7		0x03
#define BIT_8		0x04

/* Stop bits define	*/
#define STOP_1		0x01			
#define STOP_2		0x02

//ʼDLL⡣
BOOL        WINAPI CH9329DllInt();

//CH9329GetHidGuidȡHIDGUID÷οCH9329DBG
//ȼHidD_GetHidGuid,οMSDN
void        WINAPI CH9329GetHidGuid (void *   HidGuid);

// 豸VID/PID豸
// CH9329OpenDeviceɹ豸ʧܷINVALID_HANDLE_VALUE
HANDLE		WINAPI	CH9329OpenDevice(	unsigned short USB_VID,		        //豸VID
				        unsigned short USB_PID 								//豸PID
				        ); 
				        
// 豸豸
// CH9329OpenDeviceɹ豸ʧܷINVALID_HANDLE_VALUE
HANDLE	WINAPI	CH9329OpenDevicePath(PCHAR DevicePath       //豸
                        );

BOOL	WINAPI	CH9329GetDevicePath(ULONG DevIndex,         //豸ţʾϵͳеڼHID豸
                                    PCHAR DevicePath,       //豸
                                    ULONG DevicePathLen     //DevicePathĻ
                                    );				
//ȼHidD_GetAttributesȡVID,PID汾,οMSDNɹTRUE,ʧܷFALSE
unsigned long	WINAPI CH9329GetAttributes (HANDLE hDeviceHandle,           //豸
                        unsigned short * pVID,                              //豸VID
                        unsigned short * pPID,                              //豸PID
                        unsigned short * pVer                               //豸İ汾
                        );
                
//ȡCH9329ReadDataCH9329WriteDataһζдݳ
//ɹTRUEʧܷFALSE
unsigned long	WINAPI	CH9329GetBufferLen(HANDLE hDeviceHandle,	        //豸
				        unsigned short * InputReportLen,					//ؽݳ
				        unsigned short * OutputReportLen					//طݳ
				        );
				
//CH9329ReadDataCH9329WriteDataдʱλ
void		WINAPI	CH9329SetTimeOut(	HANDLE hDeviceHandle,		        //豸
				        unsigned long ReadTimeOut,							//öݳʱ
				        unsigned long SendTimeOut							//дݳʱ
				        );
				
//һݣ󳤶ΪCH9329GetBufferLenصInputReportLen-2оƬ̼.
//CH9329һ󳤶Ϊ31.ɹTRUEʧܷFALSE
unsigned long	WINAPI	CH9329ReadData(	HANDLE hDeviceHandle,		        //豸
				        void * 			ReadBuffer ,						//ָݻ
				        unsigned long * pReadLen,							//ʵʶݳ
				        HANDLE 			hEventObject						//ȴ¼
				        );
				
//дһݣ󳤶ΪCH9329GetBufferLenصOutputReportLen-2оƬ̼.
//CH9329дһ󳤶Ϊ31.ɹTRUEʧܷFALSE				
unsigned long	WINAPI	CH9329WriteData(	HANDLE hDeviceHandle,           //豸
				        void * 			SendBuffer,							//ָݻ
				        unsigned long	SentLen,							//Ҫݵĳ
				        HANDLE 			hEventObject						//ȴ¼
				        );
/*
ucRate	: 1=300(ucRateΪ1ʱӦ300),2=600,3=1200,4=2400,5=4800,6=9600(Ĭֵ),7=14400,8=19200,9=28800,10=38400,11=57600,12=76800,13=115200
ucCheck	: 1=У,2=żУ,3=հλ,4=У(Ĭֵ)
ucStop	: 1=1λ(Ĭֵ)2=2λ
ucData	1=5λ2=6λ3=7λ4=8λ(Ĭֵ)
*/
//òʣucIntervalΪݵĳʱܵ31
//ҳucIntervalʱûܵݣCH9329ϴPC
//ɹTRUEʧܷFALSE
unsigned long	WINAPI	CH9329SetRate(	HANDLE	hDeviceHandle,	            //豸
					    unsigned char	ucRate,	                            //
					    unsigned char	ucCheck,	                        //Уģʽ
					    unsigned char	ucStop,	                            //ֹͣλ
					    unsigned char	ucData,                             //λ
					    unsigned char	ucInterval                          //HIDʱʱ0x10=3MS((Ĭֵ)),0x20Լ6MS,0x30Լ9MS
					    );	
					
/*
CH9329InitThreadData,CH9329GetThreadDataLen,CH9329ClearThreadData,
CH9329ReadThreadData,CH9329StopThread
麯ҪΪ˷ݲͻʹַʽݡ
CH9329InitThreadData:һ̺߳˽жѣ߳ڲĵCH9329ReadDataݣݻڲ˽жС
CH9329GetThreadDataLen:ȡڲݵĳȡ
CH9329ReadThreadData:ڲݡ
CH9329ClearThreadData:ջݡ
CH9329StopThread:ֹͣڲ̶߳ȡڲ
*/

//ʼ̺߳˽жѣɹTRUEʧܷFALSE
unsigned long 	WINAPI	CH9329InitThreadData(HANDLE hDeviceHandle   //豸
                        );
                        
//ѯݣ̻߳ж
unsigned long 	WINAPI	CH9329GetThreadDataLen(HANDLE hDeviceHandle  //豸
                        );
//߳ݣɹTRUEʧܷFALSE
//ע⣺ReadLenڵ֮ǰΪҪȡݳȣȲܳReadBufferĴСᷢڴ
unsigned long 	WINAPI	CH9329ReadThreadData(HANDLE hDeviceHandle,  //HID豸
                        void * ReadBuffer,                          //׵ַ
                        unsigned long *ReadLen                      //֮ǰΪҪȡݳȣʵʶݳ
                        );
//ջ
void 	        WINAPI	CH9329ClearThreadData(HANDLE hDeviceHandle  //豸
                        );
                        
//ֹͣڲ̶߳ȡڲ
void 	        WINAPI	CH9329StopThread(HANDLE hDeviceHandle       //豸
                        );

//òƷϢʹãرҪעVID/PIDʱ
//豸ʱCH9329OpenDeviceӦVID/PIDҪӦ޸ģʧܡ
//ɹTRUEʧܷFALSE
unsigned long 	WINAPI	CH9329SetDeviceCfg(HANDLE hDeviceHandle,    //豸
                        unsigned short wVID,                        //µVID
                        unsigned short wPID,                        //µPID
                        unsigned short wPower,                      //µ豸,50~150 
                        char* strManufacturer,                      //µĳ
                        unsigned long  uMSlen,                      //µĳȣ29
                        char* strProduct,                           //µĲƷ
                        unsigned long  uPSlen,                      //µĲƷȣ29
                        char* strSerialNo,                          //µĲƷк
                        unsigned long  uSSlen                       //µĲƷкųȣ29
                        );

//ĬϲʣϵĬϲʣʱCH9329Ĭϲ9600οCH9329SetRate
//ɹTRUEʧܷFALSE
unsigned long	WINAPI	CH9329SetDefaultRate(	HANDLE	hDeviceHandle,	    //豸
					    unsigned char	ucRate,	                            //
					    unsigned char	ucCheck,	                        //Уģʽ
					    unsigned char	ucStop,	                            //ֹͣλ
					    unsigned char	ucData,                             //λ
					    unsigned char	ucInterval                          //HIDʱʱ0x10=3MS((Ĭֵ)),0x20Լ6MS,0x30Լ9MS
					    );	

//ָĬãʹCH9329SetDeviceCfgCH9329SetDefaultRateЧ
//ɹTRUEʧܷFALSE
unsigned long	WINAPI	CH9329ResetToDefault(	HANDLE hDeviceHandle 	        //豸
                        );
					
//16λIOڷ򣬳ɹTRUEʧܷFALSE
unsigned long 	WINAPI	CH9329SetIODir(HANDLE hDeviceHandle,                //豸
                        unsigned short usDir                                //16λIOڵãӦλ10                           
                        );
                        
//16λIOڵĵƽɹTRUEʧܷFALSE
unsigned long 	WINAPI	CH9329WriteIOData(HANDLE hDeviceHandle,             //豸
                        unsigned short usData                               //16λIOĸߵ͵ƽãӦλ1ߵƽ0صƽ
                        );

//ȡ16λIOڵŵƽɹTRUEʧܷFALSE                        
unsigned long 	WINAPI	CH9329ReadIOData(HANDLE hDeviceHandle,              //豸
                        unsigned short* pData                               //ȡ16λIOڵŵƽ
                        );   

//ȡַɹTRUEʧܷFALSE 
//ȼHidD_GetManufacturerStringοMSDN 
unsigned long 	WINAPI  CH9329GetManufacturerString (HANDLE hDeviceHandle,  //豸
                        void * Buffer,                                      //׵ַ
                        unsigned long BufferLength                          //С
                        );

//ȡƷַɹTRUEʧܷFALSE 
//ȼHidD_GetProductStringοMSDN 
unsigned long 	WINAPI  CH9329GetProductString(HANDLE hDeviceHandle,        //豸
                        void * Buffer,                                      //׵ַ
                        unsigned long BufferLength                          //С
                        );

//ȡкַɹTRUEʧܷFALSE
//ȼHidD_GetSerialNumberStringοMSDN
unsigned long 	WINAPI  CH9329GetSerialNumberString(HANDLE hDeviceHandle,   //豸
                        void * Buffer,                                      //׵ַ
                        unsigned long BufferLength                          //С
                        );                                                 


//ر豸
void 		    WINAPI	CH9329CloseDevice(HANDLE hDeviceHandle              //豸
                        );

#ifdef __cplusplus
}
#endif

#endif		// _CH9329_DLL_H
